import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { mutationResponse } from "../../util/processResponse.js";

const deleteCouponUrl = `${BASE_API_URL_STG}/user/delete-coupon`;

const initialState = {
    isLoading: false,
    couponAmount: "",
    successMessage: "",
    errorText: "",
};

export const deleteCouponThunk = createAsyncThunk(
    "cart/deleteCoupon",
    async (params) => {
        const { access_token, formData } = params;
        try {
            const res = await mutationResponse(
                deleteCouponUrl,
                "POST",
                formData,
                access_token
            );
            return res;
        } catch (err) {}
    }
);

const deleteCouponSlice = createSlice({
    name: "deleteCoupon",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(deleteCouponThunk.pending, (state) => {
            state.isLoading = true;
            state.errorText = "";
            state.successMessage = "";
        });
        builder.addCase(deleteCouponThunk.fulfilled, (state, { payload }) => {
            state.isLoading = false;
            const { status, records } = payload;
            if (status?.message === "OK") {
                state.successMessage = records?.data?.message;
                state.errorText = "";
                state.couponAmount = records?.data?.coupon_amount;
            } else {
                state.error = status?.message;
                state.successMessage = "";
            }
        });
        builder.addCase(deleteCouponThunk.rejected, (state) => {
            state.isLoading = false;
        });
    },
});

export default deleteCouponSlice.reducer;
